/** @file   ParticleGunFlames.cpp
 * @brief   Implementation of ParticleGunFlames - class.
 * @version $Revision: 1.1 $
 * @author  Tomi Lamminsaari
 */

#include "ParticleGunFlames.h"

namespace eng2d {
 
GunFlameParticle::GunFlameParticle() :
  Particle()
{
}

GunFlameParticle::~GunFlameParticle()
{
}

void GunFlameParticle::redraw( BITMAP* aCanvas, const Vec2D& aOffset ) const
{
  Vec2D pos = m_pos - aOffset;
  Vec2D oldPos = pos - m_dirVec;
  Color c;
  m_grad.color( m_timeleft, 0, m_maxlife, &c );
  line( aCanvas, pos.intX(),pos.intY(), oldPos.intX(),oldPos.intY(), c.allC() );
}
 
 
///
/// ParticleGunFlames class
///
int ParticleGunFlames::s_averageLifetime = 10;


ParticleGunFlames::ParticleGunFlames( const Vec2D& aPos,
    const Vec2D& aDir, int aNum, int aDistribution ) :
      ParticleSystem()
{
  Vec2D normDir( aDir );
  normDir.norm();
  float s = aDir.length() / 3.0;
  
  for ( int i=0; i < aNum; i++ ) {
    Particle* pP = new GunFlameParticle();
    pP->m_pos = aPos;
    pP->lifetime( s_averageLifetime + rand() % 10 );
    pP->m_grad = Gradient( Color(120,90,30), Color(170,150,80),
                           Color(230,230,180), 70 );
    pP->m_size = 1;
    int tmp = rand() % 300;
    pP->m_friction = 0.5 + (static_cast<float>(tmp)/1000.0);
    
    pP->m_dirVec = normDir;
    pP->m_dirVec *= s + ( static_cast<float>( rand() % 100 ) / 100.0 );
    pP->m_dirVec.rotate( (rand() % aDistribution) - (aDistribution/2) );
    
    this->addParticle( pP );
  }
}

ParticleGunFlames::~ParticleGunFlames()
{
}

} // end of namespace
